/*
 * Decompiled with CFR 0.152.
 */
package biz.kodl.fakt.services;

import biz.kodl.fakt.MainC;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DataMgr {
    public String sep = MainC.sep();
    public String pwd = MainC.pwd();
    public String data = "";
    public File f;
    FileOutputStream fw = null;
    ZipOutputStream zw = null;
    ZipInputStream in = null;

    public DataMgr(String data) {
        this.data = data;
        this.f = new File(this.pwd + this.sep + data);
    }

    public void listFiles(File f, boolean displ, boolean backup) {
        if (f.isDirectory()) {
            File[] fd = f.listFiles();
            for (int i = 0; i < fd.length; ++i) {
                if (this.fileToBackup(fd[i])) {
                    if (displ) {
                        System.out.println(".... entries are : " + this.relative(fd[i]));
                    }
                    if (backup & fd[i].isFile()) {
                        String s = this.relative(fd[i]);
                        this.putNextEntry(s);
                        this.writetozip(s);
                        System.out.print("o");
                    }
                }
                this.listFiles(fd[i], displ, backup);
            }
        }
    }

    public void listFilesZip(boolean display, boolean restore) {
        try {
            ZipEntry ze = this.in.getNextEntry();
            while (ze != null) {
                if (display) {
                    System.out.println("Entry name is " + ze.getName());
                }
                if (restore) {
                    this.readfromzip(ze.getName());
                    System.out.print("o");
                }
                ze = this.in.getNextEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initBacukp(File out) {
        try {
            this.fw = new FileOutputStream(out.getAbsolutePath());
            this.zw = new ZipOutputStream(this.fw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openBackupFile(File fin) {
        try {
            BufferedInputStream zin = new BufferedInputStream(new FileInputStream(fin.getPath()));
            CheckedInputStream csumi = new CheckedInputStream(zin, new Adler32());
            this.in = new ZipInputStream(csumi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.zw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closei() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean fileToBackup(File f) {
        return f.getName().toLowerCase().indexOf(".jar") <= 0 && f.getName().toLowerCase().indexOf(".zip") <= 0;
    }

    public ZipInputStream getzipstream(String zipname, String entryname) {
        try {
            BufferedInputStream zin = new BufferedInputStream(new FileInputStream(zipname));
            CheckedInputStream csumi = new CheckedInputStream(zin, new Adler32());
            ZipInputStream in = new ZipInputStream(csumi);
            ZipEntry ze = in.getNextEntry();
            while (!ze.getName().toUpperCase().equals(entryname.toUpperCase()) && ze != null) {
                ze = in.getNextEntry();
            }
            return in;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void readfromzip(String fname) {
        try {
            FileOutputStream fw = new FileOutputStream(fname);
            int i = 0;
            while (i >= -1 && (i = this.in.read()) != -1) {
                fw.write(i);
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String readfromzip(String zipname, String fname) throws IOException {
        ZipInputStream zi = this.getzipstream(zipname, fname);
        StringWriter sw = new StringWriter();
        int n = 0;
        int i = 0;
        while (i > -1) {
            i = zi.read();
            if (i != -1) {
                sw.write(i);
            }
            ++n;
        }
        zi.close();
        return sw.toString();
    }

    public void writetozip(String fname) {
        try {
            FileInputStream fr = new FileInputStream(fname);
            int i = 0;
            while (i >= -1 && (i = fr.read()) != -1) {
                this.zw.write(i);
            }
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copystream(ZipInputStream in, String fname) throws IOException {
        FileOutputStream out = new FileOutputStream(fname);
        int i = 0;
        while (i != -1 && (i = in.read()) != -1) {
            out.write(i);
        }
        in.close();
        out.close();
    }

    public void putNextEntry(File f) {
        try {
            this.zw.putNextEntry(new ZipEntry(f.getPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void putNextEntry(String f) {
        try {
            this.zw.putNextEntry(new ZipEntry(f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String relative(File f) {
        String s = f.getAbsolutePath();
        int i = s.toUpperCase().indexOf(this.data.toUpperCase());
        return s.substring(i);
    }
}

