/*
 * Decompiled with CFR 0.152.
 */
package biz.kodl.fakt.data;

import biz.kodl.fakt.data.FarRec;
import biz.kodl.fakt.gui.Tab;
import biz.kodl.fakt.services.Book;
import biz.kodl.fakt.services.MyDate;
import biz.kodl.fakt.services.Record;
import biz.kodl.fakt.services.UnicodeManipulator;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;

public class FarBook
extends Book {
    UnicodeManipulator um = new UnicodeManipulator();

    public FarBook() {
        super.init("OBJR", "faktr.dbf");
        String[] rown = new String[]{"ID", "IDH", "IDO", "IDC", "TC", "DATE", "QUANT", "PRICE", "DISC", "VAT", "TEXT", "SORT", "MJ"};
        this.rown = rown;
    }

    public FarRec getr(int i) {
        return (FarRec)this.mainlist.get(i);
    }

    public Record converttoelement() throws SQLException {
        FarRec r = (FarRec)super.converttoelement();
        int i = 0;
        r.id = this.rs.getInt(this.rown[i++]);
        r.idh = this.rs.getInt(this.rown[i++]);
        r.ido = this.rs.getInt(this.rown[i++]);
        r.idc = this.rs.getInt(this.rown[i++]);
        r.tc = this.rs.getInt(this.rown[i++]);
        r.date = new MyDate(this.rs.getDate(this.rown[i++]));
        r.qu = new BigDecimal(this.rown[i++]);
        r.pr = new BigDecimal(this.rown[i++]);
        r.di = new BigDecimal(this.rown[i++]);
        r.vat = new BigDecimal(this.rown[i++]);
        r.text = this.um.fromUnicode(this.rs.getString(this.rown[i++]));
        r.sort = this.rs.getInt(this.rown[i++]);
        r.mj = this.um.fromUnicode(this.rs.getString(this.rown[i++]));
        return r;
    }

    public void converttorecord(Object[] c, int ix) {
        FarRec rec = this.getr(ix);
        int i = 0;
        c[i++] = new Integer(rec.id);
        c[i++] = new Integer(rec.idh);
        c[i++] = new Integer(rec.ido);
        c[i++] = new Integer(rec.idc);
        c[i++] = new Integer(rec.tc);
        c[i++] = rec.date.orig;
        c[i++] = rec.qu;
        c[i++] = rec.pr;
        c[i++] = rec.di;
        c[i++] = rec.vat;
        int n = i++;
        c[n] = UnicodeManipulator.toUnicode(rec.text);
        c[i++] = new Integer(rec.sort);
        int n2 = i++;
        c[n2] = UnicodeManipulator.toUnicode(rec.mj);
    }

    public void convertrectorow(Record r, Object[] data) {
        FarRec rad = new FarRec();
        int i = 0;
        if (data[i] instanceof Number) {
            rad.id = ((Number)data[i]).intValue();
        }
        if (data[++i] instanceof Number) {
            rad.idh = ((Number)data[i]).intValue();
        }
        if (data[++i] instanceof Number) {
            rad.ido = ((Number)data[i]).intValue();
        }
        if (data[++i] instanceof Number) {
            rad.idc = ((Number)data[i]).intValue();
        }
        if (data[++i] instanceof Number) {
            rad.tc = ((Number)data[i]).intValue();
        }
        if (data[++i] instanceof Date) {
            rad.date = new MyDate((Date)data[i]);
        }
        if (data[++i] instanceof Number) {
            rad.qu = new BigDecimal(data[i].toString());
        }
        if (data[++i] instanceof Number) {
            rad.pr = new BigDecimal(data[i].toString());
        }
        if (data[++i] instanceof Number) {
            rad.di = new BigDecimal(data[i].toString());
        }
        if (data[++i] instanceof Number) {
            rad.vat = new BigDecimal(data[i].toString());
        }
        if (data[++i] instanceof String) {
            rad.text = this.um.fromUnicode((String)data[i]);
        }
        if (data[++i] instanceof Number) {
            rad.sort = ((Number)data[i]).intValue();
        }
        if (data[++i] instanceof String) {
            rad.mj = this.um.fromUnicode((String)data[i]);
        }
        this.mainlist.add(rad);
    }

    public void filter(Tab st, String s, int id) {
        this.mainlist = new Vector();
        int n = this.orig.size();
        for (int i = 0; i < n; ++i) {
            FarRec sr = (FarRec)this.orig.get(i);
            if (sr.idh != id) continue;
            this.mainlist.add(sr);
        }
        st.reallocateIndexes();
        st.fireTableDataChanged();
    }

    public void filter(Tab st, String s) {
        this.mainlist = new Vector();
        int n = this.orig.size();
        for (int i = 0; i < n; ++i) {
            FarRec sr = (FarRec)this.orig.get(i);
            if (sr.date.deur().toUpperCase().indexOf(s.toUpperCase()) < 0 && sr.text.toUpperCase().indexOf(s.toUpperCase()) < 0) continue;
            this.mainlist.add(sr);
        }
        st.reallocateIndexes();
        st.fireTableDataChanged();
    }

    public FarRec findidc(int id, int t) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FarRec or = this.getr(i);
            if (or.idc == id && or.tc == t) {
                return this.getr(i);
            }
            if (or.idc != id || t != 0) continue;
            return this.getr(i);
        }
        return null;
    }

    public FarRec findidc(int id, Vector v, int t) {
        Vector vv = this.mainlist;
        this.mainlist = v;
        FarRec rec = this.findidc(id, t);
        this.mainlist = vv;
        return rec;
    }

    public void sort() {
        Collections.sort(this.mainlist, new Comparator(){

            public int compare(Object o1, Object o2) {
                FarRec a = (FarRec)o1;
                FarRec b = (FarRec)o2;
                if (a.idh != b.idh) {
                    return a.idh - b.idh;
                }
                return a.sort - b.sort;
            }
        });
        Collections.sort(this.orig, new Comparator(){

            public int compare(Object o1, Object o2) {
                FarRec a = (FarRec)o1;
                FarRec b = (FarRec)o2;
                if (a.idh != b.idh) {
                    return a.idh - b.idh;
                }
                return a.sort - b.sort;
            }
        });
    }

    void refrprices(JTable objjt, Tab st) {
        int i = objjt.getSelectedRow();
        if (i < 0) {
            return;
        }
        int id = (Integer)objjt.getValueAt(i, 0);
        for (int ia = 0; ia < this.mainlist.size(); ++ia) {
            FarRec or = this.getr(ia);
            if (or.idh == id && or.tc != 1) continue;
        }
        st.fireTableDataChanged();
    }

    double gettotal(int i) {
        FarRec fr = this.getr(i);
        return fr.getPriceBig().doubleValue();
    }

    double gettotal(JTable jt, Tab t) {
        int i = jt.getSelectedRow();
        if (i < 0) {
            return 0.0;
        }
        int n = t.indexes[i];
        return this.gettotal(n);
    }

    public void rereadfak(int id, Tab t) {
        Vector<FarRec> v = new Vector<FarRec>();
        this.restv();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getr((int)i).idh != id) continue;
            v.add(this.getr(i));
        }
        this.mainlist = v;
        t.reallocateIndexes();
        t.fireTableDataChanged();
    }

    public void delAnyFak(int id) {
        this.restv();
        for (int ia = 0; ia < this.mainlist.size(); ++ia) {
            if (this.getr((int)ia).idh != id) continue;
            this.mainlist.remove(ia);
            --ia;
        }
        this.savev();
        this.mainlist = new Vector();
    }

    public Vector getRowsOfInv(int idh) {
        Vector<FarRec> v = new Vector<FarRec>();
        for (int i = 0; i < this.orig.size(); ++i) {
            FarRec f = (FarRec)this.orig.get(i);
            if (f.idh != idh) continue;
            v.add(f);
        }
        return v;
    }

    public void list(Vector rows) {
        if (rows == null) {
            System.out.println("Vector with rows is null ...");
            return;
        }
        for (int i = 0; i < rows.size(); ++i) {
            FarRec fr = (FarRec)rows.get(i);
            System.out.println(" .... row " + fr.id + " / " + fr.idh + " / " + fr.date + " / " + fr.text + " / " + fr.mj + " / " + fr.qu + " / " + fr.pr + " / " + fr.vat);
        }
    }
}

