<?php

/**
 * funkce pro zobrazení celé článku
 */
function templatePerexContent($name, $date, $author, $rubrics, $perex, $content, $link, $address, $comments, $_GET = NULL, $comments_esc, $tags, $comments_set, $lang) {

    /* tělo článku */
    echo "<div class=\"post\">";
    echo "<div class=\"post_title\"><h2><a href=\"$link\">$name</a></h2></div>\n"; /* Nadpis článku $name a odkaz na článek $link */
    echo "<div class=\"post_date\">$date " . $lang['author'] . " $author</div>\n"; /* Datum vytvoŕení článku $date a jméno autora $author */
    echo "<div class=\"post_body\">";
    echo $perex . "\n"; /* popis článku $perex */
    echo $content . "\n"; /* obsah článku $content */
    echo "</div>";
    echo "<div class=\"post_meta\">"; /* začátek lišty s dalšími informacemi */
    echo showRubric($_GET, $rubrics, $lang); /* zobrazení rubriky */    
    if($comments_set == "allow"){
        echo " <a href=\"$link#endpage\">$comments $comments_esc &raquo;</a>"; /* Zobrazení počtu komentářů $comments se stupňováním sloma Komentář $commenst_sec a okdazu na konec článku $link */        
    }
    echo " | " . $lang['tags'] . " ";
    echo showTag($tags); /* zobrazení štítků */
    echo "</div>";
    echo "</div>";
}

/**
 * funkce pro zobrazení článku pouze s perexem, používá se v seznamu článků
 */
function templatePerex($name, $date, $author, $rubrics, $perex, $content, $link, $address, $comments, $comments_esc, $tags,  $comments_set, $lang) {

    /* tělo článku */
    echo "<div class=\"post\">";
    echo "<div class=\"post_title\"><h2><a href=\"$link\">$name</a></h2></div>\n";
    echo "<div class=\"post_date\">$date " . $lang['author'] . " $author</div>\n";
    echo "<div class=\"post_body\">";
    echo $perex . "\n\n";
    echo "</div>";
    echo "<div class=\"post_meta\">";
    echo showRubric($_GET, $rubrics, $lang); /* zobrazení rubriky */
    if($comments_set == "allow"){
        echo "  <a href=\"$link#endpage\">$comments $comments_esc &raquo;</a>";
    }
    echo " | " . $lang['tags'] . " ";
    echo showTag($tags);
    echo "</div>";
    echo "</div>";
}

/**
 * funkce pro zobrazení galerie
 */
function templateGallery($name, $content, $comments, $date, $author, $fullname, $tag, $link, $n_comments, $comments_esc, $lang) {

    /* tělo galerie */
    echo "<div class=\"post\">";
    echo "<div class=\"post_title\"><h1><a href=\"$link\">$name</a></h2></div>\n";
    echo "<div class=\"post_date\">$date " . $lang['author'] . " $author</div>\n";
    echo "<div class=\"post_body\">";
    echo $content . "\n\n";
    galleryPrinter();
    echo "</div>";
    echo "<div class=\"post_meta\">";
    //echo showRubric($_GET, $rubrics); /*zobrazení rubriky*/
    echo "<a href=\"$link#endpage\">$n_comments $comments_esc &raquo;</a>";
    echo " | " . $lang['tags'] . " ";
    echo showTag($tag);
    echo "</div>";
    echo "</div>";
}

function templateCommentsForm($comments, $lang) {

    /* tělo formuláře pro komentáře */
    echo '

        
          <form action="#endpage" method="post" id="reply">
            <fieldset>
                <div class="legend"><h3>'. $lang['comments'] .'</h3></div>
                    <div class="form_row">                                
                        <div class="form_property form_required">'. $lang['label_name'] .'</div>
                        <div class="form_value"><input type="text" name="author" value="" size="32"/></div>
                        <div class="clearer">&nbsp;</div>
                    </div>
                    
                    <div class="form_row">                                
                        <div class="form_property">'. $lang['label_mail'] .'</div>
                        <div class="form_value"><input type="text" name="email" value="@" size="32"/></div>
                        <div class="clearer">&nbsp;</div>
                    </div>
                    
                    <div class="form_row">                                
                        <div class="form_property">'. $lang['label_web'] .'</div>
                        <div class="form_value"><input type="text" name="url" value="http://" size="32"/></div>
                        <div class="clearer">&nbsp;</div>
                    </div>
                    
                    <div class="form_row">                                
                        <div class="form_property form_required">'. $lang['comment'] .'</div>
                        <div class="form_value"><textarea name="comment" rows="10" cols="46"></textarea></div>
                        <div class="clearer">&nbsp;</div>
                    </div>

                    <input type="hidden" name="send" value="true">
                    
                    <div class="form_row form_row_submit">
                        <div class="form_value"><input name="submit" type="submit" class="button" value="'. $lang['value_send_comment'] .'" /></div>
                        <div class="clearer">&nbsp;</div>
                    </div>

                </fieldset>
          </form>
    ';
}

function templateCommentsCase($comment_content, $comments) {
    list($name, $date, $email, $url, $text) = explode("!mpc#!", $comment_content);
    $date = substractDate($date, 1);

    /* tělo komentáře v HTML */
    echo '<div class="comment">';
    echo '<div class="comment_author left">';
    echo $name.' <div class="comment_date">' . $date . ' <a href="' . $url . '" rel="' . $comments['rel'] . '">Link</a></div>';
    echo '</div>';    
    echo '<div class="clearer">&nbsp;</div>';
    echo '<div class="comment_body">' . $text . '</div>';
    echo '</div>';
}

function templateLoginForm($lang) {

    /* tělo pŕihlašovacího formuláře v HTML */
    echo '<h2>' . $lang['login'] . '</h2>
        <ul>
          <li>
            <form method="post" id="search_form">
              <input type="text" name="name" id="text">
              <input type="password" name="pass" id="text">  
              <input type="hidden" name="login-hidden" value="true">
               <input type="submit" value="' . $lang['login_button'] . '" id="button">       
            </form>  
          </li>
          <li>
          '. $lang['register'] .' | '. $lang['forgot_password'] .'
          </li>
       </ul>
      ';
}

/*
function lists($lang, $address, $web, $type){    
    echo "<h2>".$lang."</h2>";
    echo "<ul>";
    li_generator($address, FALSE, $web);
    echo "</ul>";           
}
*/



?>