/*
 * Decompiled with CFR 0.152.
 */
package biz.kodl.fakt.services;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class MyRowEditor
implements TableCellEditor {
    protected Hashtable editors;
    protected TableCellEditor editor;
    protected TableCellEditor defaultEditor;
    JTable table;
    int row;
    int column;
    JTextField f;

    public MyRowEditor(JTable table) {
        this.table = table;
        this.editors = new Hashtable();
        this.f = new JTextField();
        this.f.setBackground(new Color(180, 0, 0, 255));
        this.f.setForeground(new Color(255, 255, 0, 255));
        this.f.setBorder(null);
        this.defaultEditor = new DefaultCellEditor(this.f);
    }

    void erase() {
        if (this.f.getText().equals("0.0")) {
            this.f.setText("0");
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Object getCellEditorValue() {
        String s = this.editor.getCellEditorValue().toString();
        Object o = this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        if (o instanceof Double) {
            s = s.replaceAll(",", ".");
            return s;
        }
        return this.editor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        this.selectEditor(anEvent);
        return this.editor.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.erase();
        this.editor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    public void setEditorAt(int row, TableCellEditor editor) {
        this.editors.put(new Integer(row), editor);
    }

    protected void selectEditor(EventObject e) {
        int row = 0;
        this.erase();
        if (e == null) {
            row = this.table.getSelectionModel().getAnchorSelectionIndex();
        } else if (e instanceof MouseEvent) {
            row = this.table.rowAtPoint(((MouseEvent)e).getPoint());
        }
        this.editor = (TableCellEditor)this.editors.get(new Integer(row));
        if (this.editor == null) {
            this.editor = this.defaultEditor;
        }
    }
}

