/*
 * Decompiled with CFR 0.152.
 */
package biz.kodl.fakt.services;

import biz.kodl.fakt.MainC;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class MyMultiRowEditor
implements TableCellEditor {
    protected Hashtable editors;
    protected TableCellEditor editor;
    protected TableCellEditor defaultEditor;
    JTable table;
    int row;
    int column;
    JTextField f;
    JEditorPane jt = new JEditorPane("text/plain", "");
    JFrame fra = new JFrame("");
    final JDialog fr = new JDialog(this.fra);
    int erow;
    int ecolumn;

    public MyMultiRowEditor(JTable table) {
        this.table = table;
        this.editors = new Hashtable();
        JScrollPane st = new JScrollPane(this.jt);
        st.setHorizontalScrollBarPolicy(31);
        this.jt.setToolTipText(MainC.text(122));
        this.f = new JTextField();
        this.f.setBackground(new Color(180, 0, 0, 255));
        this.f.setForeground(new Color(255, 255, 0, 255));
        this.f.setBorder(null);
        this.fr.setSize(500, 170);
        this.fr.getContentPane().add(st);
        this.fr.setTitle("EDITACE ...  Ulozen\u00ed [CTRL]+[ENTER]");
        this.fr.setModal(true);
        this.jt.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.isControlDown()) {
                    MyMultiRowEditor.this.savevalue();
                }
                if (e.getKeyCode() == 27) {
                    MyMultiRowEditor.this.cancel();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.f.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                MyMultiRowEditor.this.loadvalue();
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.defaultEditor = new DefaultCellEditor(this.f);
    }

    void cancel() {
        this.fr.hide();
        this.table.resetKeyboardActions();
    }

    void savevalue() {
        String s = this.jt.getText();
        s = this.defilter(s);
        this.table.setValueAt(s, this.erow, this.ecolumn);
        this.f.setText(s);
        this.fr.hide();
        this.table.resetKeyboardActions();
    }

    void loadvalue() {
        this.cancelCellEditing();
        this.defaultEditor.cancelCellEditing();
        this.jt.setText(this.refilter(this.editor.getCellEditorValue().toString()));
        this.fr.show();
        this.fr.setModal(true);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    String defilter(String s) {
        s = s.replaceAll("\n", new String("\u0004"));
        s = s.replaceAll("\r", "");
        return s;
    }

    String refilter(String s) {
        s = s.replaceAll("\u0004", "\r\n");
        return s;
    }

    public Object getCellEditorValue() {
        String s = this.editor.getCellEditorValue().toString();
        Object o = this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        s = this.jt.getText();
        s = this.defilter(s);
        if (o instanceof Double) {
            s = s.replaceAll(",", ".");
            return s;
        }
        return s;
    }

    public boolean isCellEditable(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    public void setEditorAt(int row, TableCellEditor editor) {
        this.editors.put(new Integer(row), editor);
    }

    protected void selectEditor(MouseEvent e) {
        int row;
        Object original = null;
        if (e == null) {
            this.erow = row = this.table.getSelectionModel().getAnchorSelectionIndex();
            this.ecolumn = this.table.getEditingColumn();
            original = this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        } else {
            this.erow = row = this.table.rowAtPoint(e.getPoint());
            this.ecolumn = this.table.columnAtPoint(e.getPoint());
            original = this.table.getValueAt(this.erow, this.ecolumn);
        }
        this.editor = (TableCellEditor)this.editors.get(new Integer(row));
        if (this.editor == null) {
            this.editor = this.defaultEditor;
        }
        if (e == null) {
            // empty if block
        }
        if (original == null) {
            original = new String();
        }
        this.jt.setText(this.refilter(original.toString()));
        this.fr.show();
        this.fr.setModal(true);
    }
}

