/*
 * Decompiled with CFR 0.152.
 */
package biz.kodl.fakt.gui;

import biz.kodl.fakt.services.Book;
import biz.kodl.fakt.services.HRender;
import biz.kodl.fakt.services.MyMultiRowEditor;
import biz.kodl.fakt.services.MyRowEditor;
import biz.kodl.fakt.services.NumberRenderer;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class Tab
extends AbstractTableModel {
    public int[] indexes;
    Vector sortingColumns = new Vector();
    Vector ascending = new Vector();
    Vector arrows = new Vector();
    int countr = 500;
    int compares;
    TableColumnModel columnModel = null;
    public String[] colname = new String[]{"First", "Second", "...", "..."};
    public int[] cowidth = new int[]{40, 40, 40, 40, 40, 50};
    public TableCellRenderer[] renderer = new TableCellRenderer[]{new NumberRenderer(), new NumberRenderer(), new NumberRenderer(), new NumberRenderer(), new NumberRenderer(), new NumberRenderer(), new NumberRenderer(), null, null};
    public int[] ceditor = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public String[] tooltips = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    public Book book = new Book();

    public Tab() {
        this.reallocateIndexes();
    }

    public int toi(Object val) {
        return new Integer(val.toString());
    }

    public double tod(Object val) {
        return new Double(val.toString());
    }

    public BigDecimal toBig(Object val, int rate) {
        try {
            return new BigDecimal(val.toString().replaceAll(",", ".")).setScale(rate, 4);
        }
        catch (Exception e) {
            return new BigDecimal(0.0);
        }
    }

    public String tos(Object val, int l) {
        String s = val.toString();
        if (l > s.length()) {
            return s;
        }
        return s.substring(0, l);
    }

    public int getRowCount() {
        if (this.book == null) {
            return 0;
        }
        return this.book.size();
    }

    public int getColumnCount() {
        return this.colname.length;
    }

    public Object getValueAtInd(int rowIndex, int columnIndex) {
        return null;
    }

    public Object getValueAt(int aRow, int aColumn) {
        if (this.indexes.length == 0) {
            this.reallocateIndexes();
        }
        try {
            return this.getValueAtInd(this.indexes[aRow], aColumn);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAtInd(Object val, int row, int col) {
        this.fireTableDataChanged();
    }

    public void setValueAt(Object val, int aRow, int aColumn) {
        this.checkModel();
        if (this.indexes.length == 0) {
            this.reallocateIndexes();
        } else {
            this.setValueAtInd(val, this.indexes[aRow], aColumn);
        }
    }

    public String getColumnName(int column) {
        if (column >= this.colname.length) {
            return "";
        }
        return this.colname[column];
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public void reallocateIndexes() {
        int rowCount = this.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void checkModel() {
        if (this.indexes.length != this.getRowCount()) {
            System.err.println("Sorter nebyl informovan o zmene modelu.");
            this.reallocateIndexes();
        }
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.getColumnClass(column);
        Object o1 = this.getValueAt(row1, column);
        Object o2 = this.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Integer) {
            Number n2;
            int d2;
            Number n1 = (Number)this.getValueAt(row1, column);
            int d1 = n1.intValue();
            if (d1 < (d2 = (n2 = (Number)this.getValueAt(row2, column)).intValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (o1 instanceof Double) {
            Double d2;
            double n2;
            Double d1 = (Double)this.getValueAt(row1, column);
            double n1 = d1;
            if (n1 < (n2 = (d2 = (Double)this.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (o1 instanceof Date) {
            Date d2;
            long n2;
            Date d1 = (Date)this.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)this.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (o1 instanceof String) {
            String s22;
            String s1 = (String)this.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)this.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (o1 instanceof Boolean) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)this.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)this.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = this.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = this.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return (Boolean)this.ascending.elementAt(level) != false ? result : -result;
        }
        return 0;
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(i, j) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void mysort(int beg, int end) {
        int cc = 0;
        int mid = (end + beg) / 2;
        int begi = beg;
        for (int endi = mid; endi <= end && begi < endi; ++begi, ++endi) {
            if (this.compare(this.indexes[begi], this.indexes[endi]) != 1) continue;
            this.swap(begi, endi);
            ++cc;
        }
        if (mid > beg) {
            this.mysort(beg, mid);
        }
        if (mid < end - 1) {
            this.mysort(mid, end);
        }
        if (cc != 0) {
            this.mysort(beg, mid);
        }
    }

    public int mybubble(int beg, int end, int step) {
        int endi;
        int cc = 0;
        int begi = beg;
        for (endi = beg + step; endi <= end && begi < endi; ++begi, ++endi) {
            if (this.compare(begi, endi) != 1) continue;
            this.swap(begi, endi);
            ++cc;
        }
        if (step < 2 && cc > 0) {
            begi = end - step;
            endi = end;
            while (begi >= 0) {
                if (this.compare(begi, endi) == 1) {
                    this.swap(begi, endi);
                    ++cc;
                }
                --begi;
                --endi;
            }
        }
        return cc;
    }

    public void mybubblesort(int beg, int end) {
        int mid;
        int cc = 0;
        int ca = 0;
        int step = mid = (end + beg) / 2;
        while (true) {
            cc = this.mybubble(beg, end, step);
            if ((step /= 2) == 0 && cc == 0 || ++ca > 100) break;
            if (step != 0) continue;
            step = 1;
        }
    }

    void qsort(int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        while (lo < hi) {
            while (lo < hi && this.compare(mid, lo) == 1) {
                ++lo;
            }
            while (lo < hi && this.compare(hi, mid) == 1) {
                --hi;
            }
            if (lo >= hi) continue;
            this.swap(lo, hi);
            if (mid == lo) {
                mid = hi;
            } else if (mid == hi) {
                mid = lo;
            }
            ++lo;
            --hi;
        }
        if (hi < lo) {
            int T = hi;
            hi = lo;
            lo = T;
        }
        this.qsort(lo0, lo);
        this.qsort(lo == lo0 ? lo + 1 : lo, hi0);
    }

    void qqsort(int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (lo >= hi) {
            return;
        }
        if (hi - lo < this.countr) {
            this.mybubblesort(lo, hi);
        } else {
            int mid = (lo + hi) / 2;
            while (lo < hi) {
                while (lo < hi && this.compare(mid, lo) == 1) {
                    ++lo;
                }
                while (lo < hi && this.compare(hi, mid) == 1) {
                    --hi;
                }
                if (lo >= hi) continue;
                this.swap(lo, hi);
                if (mid == lo) {
                    mid = hi;
                } else if (mid == hi) {
                    mid = lo;
                }
                ++lo;
                --hi;
            }
            if (hi < lo) {
                int T = hi;
                hi = lo;
                lo = T;
            }
            this.qqsort(lo0, lo);
            this.qqsort(lo == lo0 ? lo + 1 : lo, hi0);
        }
    }

    public void sort() {
        this.reallocateIndexes();
        this.checkModel();
        this.compares = 0;
        this.qqsort(0, this.getRowCount() - 1);
    }

    public void sortByColumn(int column, boolean asc) {
        if (this.sortingColumns.size() == 1 && (Integer)this.sortingColumns.elementAt(0) == column) {
            if (((Boolean)this.ascending.elementAt(0)).booleanValue()) {
                this.ascending.setElementAt(new Boolean(false), 0);
            } else {
                this.ascending.setElementAt(new Boolean(true), 0);
            }
            asc = (Boolean)this.ascending.elementAt(0);
        } else {
            this.sortingColumns.removeAllElements();
            this.ascending.removeAllElements();
            this.sortingColumns.addElement(new Integer(column));
            this.ascending.addElement(new Boolean(asc));
        }
        String arrow = "images/Arrow_dn.gif";
        if (asc) {
            arrow = "images/Arrow_up.gif";
        }
        this.columnModel.getColumn(column).setHeaderRenderer(new HRender(this.colname[column], arrow));
        this.sort();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void sortByColumns(int column, boolean asc) {
        int found = -1;
        for (int i = 0; found == -1 && i < this.ascending.size(); ++i) {
            if ((Integer)this.sortingColumns.elementAt(i) != column) continue;
            found = i;
            if (((Boolean)this.ascending.elementAt(i)).booleanValue()) {
                this.ascending.setElementAt(new Boolean(false), i);
            } else {
                this.ascending.setElementAt(new Boolean(true), i);
            }
            asc = (Boolean)this.ascending.elementAt(i);
        }
        if (found == -1) {
            this.sortingColumns.addElement(new Integer(column));
            this.ascending.addElement(new Boolean(asc));
        }
        int ind = this.sortingColumns.indexOf(new Integer(column)) + 1;
        String inds = "" + ind;
        if (ind > 6) {
            inds = "";
        }
        String arrow = "images/Arrow_dn_i" + inds + ".gif";
        if (asc) {
            arrow = "images/Arrow_up_i" + inds + ".gif";
        }
        this.columnModel.getColumn(column).setHeaderRenderer(new HRender(this.colname[column], arrow));
        this.sort();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void initheaders(JTable table) {
        JTable tableView = table;
        this.columnModel = tableView.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String arrow = "";
            this.columnModel.getColumn(i).setMinWidth(0);
            this.columnModel.getColumn(i).setHeaderRenderer(new HRender(this.colname[i], arrow, this.tooltips[i]));
            this.columnModel.getColumn(i).setPreferredWidth(this.cowidth[i]);
            this.columnModel.getColumn(i).setCellRenderer(this.renderer[i]);
            if (this.ceditor[i] == 1) {
                this.columnModel.getColumn(i).setCellEditor(new MyRowEditor(table));
            }
            if (this.ceditor[i] == 2) {
                this.columnModel.getColumn(i).setCellEditor(new DefaultCellEditor(new JCheckBox()));
            }
            if (this.ceditor[i] != 3) continue;
            this.columnModel.getColumn(i).setCellEditor(new MyMultiRowEditor(table));
        }
    }

    public void addMouseListenerToHeaderInTable(final JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Tab.this.columnModel = tableView.getColumnModel();
                int viewColumn = Tab.this.columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    boolean asc;
                    int ctrlPressed = e.getModifiers() & 2;
                    int shiftPressed = e.getModifiers() & 1;
                    boolean bl = asc = ctrlPressed == 0;
                    if (shiftPressed == 0) {
                        Tab.this.initheaders(table);
                        Tab.this.sortByColumn(column, asc);
                    }
                    if (shiftPressed == 1) {
                        Tab.this.sortByColumns(column, asc);
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public int scrollToEnd(JTable t) {
        boolean test = false;
        if (this.book.size() > 0) {
            this.scrollTo(t, this.book.size() - 1);
        }
        if (test) {
            System.out.println("Size of book is.." + this.book.size());
        }
        return 0;
    }

    public void scrollTo(JTable t, int row) {
        int last = row;
        t.addRowSelectionInterval(last, last);
        Rectangle rectang = t.getCellRect(last, 0, true);
        t.scrollRectToVisible(rectang);
    }
}

