/*
 * Decompiled with CFR 0.152.
 */
package biz.kodl.fakt.gui;

import biz.kodl.fakt.MainC;
import biz.kodl.fakt.data.FakBook;
import biz.kodl.fakt.data.FakRec;
import biz.kodl.fakt.data.FarBook;
import biz.kodl.fakt.data.FarRec;
import biz.kodl.fakt.data.TxtRec;
import biz.kodl.fakt.data.odb.OdbBook;
import biz.kodl.fakt.data.odb.OdbRec;
import biz.kodl.fakt.gui.Configurator2;
import biz.kodl.fakt.services.UnicodeManipulator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import javax.swing.JFileChooser;

public class Exporter {
    String EX_FILE_NAME = "export.dta";
    String[] HEAD = new String[]{"###### Export file", "##### Customer ", "#### Invoice head  ", "### Row"};
    String SEP = ";;";
    BufferedWriter out;
    BufferedReader in;
    String NEW_L = "\n";
    OdbBook odb = MainC.odb;
    FakBook fak = MainC.fak;
    FarBook far = MainC.far;
    File f;
    UnicodeManipulator um = new UnicodeManipulator();
    Configurator2 conf2 = MainC.conf2;
    int custId = 0;
    int invId = 0;

    public void export() {
        this.f = this.selectFile(MainC.text(194), MainC.text(89));
        if (this.f == null) {
            return;
        }
        try {
            this.out = new BufferedWriter(new FileWriter(this.f.getAbsolutePath()));
            this.out.write(this.HEAD[0] + this.NEW_L);
            this.exportInvoice();
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File selectFile(String title, String ok) {
        int PATH_P = 18;
        String data = "data";
        String sep = MainC.sep();
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        fc.setApproveButtonText(ok);
        String fname = MainC.pwd() + sep + data;
        String s = MainC.conf2.getTxtPar(MainC.conf2.PATH_P);
        if (s.length() > 1) {
            fname = s;
        }
        fname = fname + sep + this.EX_FILE_NAME;
        fc.setSelectedFile(new File(fname));
        int i = fc.showOpenDialog(MainC.mainf);
        if (i == 0) {
            File f = fc.getSelectedFile();
            MainC.conf2.localProp.setProperty(MainC.conf2.PATH_P, "" + f.getParentFile());
            MainC.conf2.writep();
            return f;
        }
        return null;
    }

    public void exportInvoice() throws IOException {
        for (int i = 0; i < this.fak.size(); ++i) {
            FakRec fr = (FakRec)this.fak.get(i);
            if (!fr.sel) continue;
            this.exportCustomer(fr.odbid);
            TxtRec txt = (TxtRec)MainC.txb.findid(fr.id);
            if (txt == null) {
                txt = new TxtRec();
            }
            String s = this.HEAD[2] + this.SEP + fr.cislo + this.SEP + fr.datum.deur() + this.SEP + fr.uhr + this.SEP + fr.splat.deur() + this.SEP + fr.pln.deur() + this.SEP + fr.pay + this.SEP + fr.send + this.SEP + fr.zapl + this.SEP + fr.ks + this.SEP + txt.txt + this.SEP + this.NEW_L;
            s = UnicodeManipulator.toUnicode(s);
            this.out.write(s);
            this.exportRows(fr.id);
        }
    }

    public void exportCustomer(int id) throws IOException {
        if (id == 0) {
            this.out.write(this.HEAD[1] + this.SEP + this.NEW_L);
            return;
        }
        OdbRec or = (OdbRec)this.odb.findid(id, this.odb.orig);
        String s = this.HEAD[1] + this.SEP + or.name + this.SEP + or.adrline + this.SEP + or.adrline2 + this.SEP + or.psc + this.SEP + or.ico + this.SEP + or.dic + this.SEP + or.contact + this.SEP + or.platce + this.SEP + or.email + this.SEP + or.html + this.SEP + or.text + this.SEP + this.NEW_L;
        s = UnicodeManipulator.toUnicode(s);
        this.out.write(s);
    }

    public void exportRows(int id) throws IOException {
        int size = this.far.orig.size();
        for (int i = 0; i < size; ++i) {
            FarRec fr = (FarRec)this.far.orig.get(i);
            if (fr.idh != id) continue;
            String s = this.HEAD[3] + this.SEP + fr.sort + this.SEP + fr.date.deur() + this.SEP + fr.qu + this.SEP + fr.pr + this.SEP + fr.di + this.SEP + fr.vat + this.SEP + fr.text + this.SEP + fr.mj + this.SEP + this.NEW_L;
            s = UnicodeManipulator.toUnicode(s);
            this.out.write(s);
        }
    }

    public void invImport() {
        this.f = this.selectFile(MainC.text(196), MainC.text(126));
        if (this.f == null) {
            return;
        }
        try {
            this.in = new BufferedReader(new FileReader(this.f.getAbsolutePath()));
            if (this.in.ready()) {
                String line = this.um.fromUnicode(this.in.readLine());
                if (line.equals(this.HEAD[0])) {
                    // empty if block
                }
                this.importBody();
            }
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void importBody() throws IOException {
        while (this.in.ready()) {
            String line = this.um.fromUnicode(this.in.readLine());
            String[] data = line.split(this.SEP);
            if (data[0].equals(this.HEAD[1])) {
                this.addCustomer(data);
            }
            if (data[0].equals(this.HEAD[2])) {
                this.addInvoice(data);
            }
            if (!data[0].equals(this.HEAD[3])) continue;
            this.addRows(data);
        }
    }

    public void addCustomer(String[] s) {
        if (s.length == 1) {
            this.custId = 0;
            return;
        }
        OdbRec or = this.odb.findIcoDic(s[5], s[6]);
        if (or == null) {
            or = new OdbRec();
            or.id = this.odb.countmax(this.odb.orig) + 1;
            or.name = s[1];
            or.adrline = s[2];
            or.adrline2 = s[3];
            or.psc = s[4];
            or.ico = s[5];
            or.dic = s[6];
            or.contact = s[7];
            or.platce = new Boolean(s[8]);
            or.email = s[9];
            if (s.length > 10) {
                or.html = s[10];
            }
            if (s.length > 11) {
                or.text = s[11];
            }
            this.odb.addrec(MainC.odber.odbjt, MainC.odber.odbt, this.odb.orig, or, or.id);
        }
        this.custId = or.id;
    }

    public void addInvoice(String[] s) {
        FakRec fr = new FakRec();
        fr.id = this.fak.countmax(this.fak.orig) + 1;
        fr.cislo = s[1];
        fr.datum.set(s[2]);
        fr.uhr = s[3];
        fr.splat.set(s[4]);
        fr.pln.set(s[5]);
        fr.pay = new Boolean(s[6]);
        fr.send = new Boolean(s[7]);
        if (s.length > 8) {
            fr.zapl = s[8];
        }
        if (s.length > 9) {
            fr.ks = s[9];
        }
        fr.odbid = this.custId;
        this.fak.addrec(MainC.faktur.fakjt, MainC.faktur.fakt, this.fak.orig, fr, fr.id);
        if (s.length == 11) {
            MainC.txb.update(fr.id, s[10]);
        }
        this.invId = fr.id;
    }

    public void addRows(String[] s) {
        FarRec fr = new FarRec();
        fr.id = this.far.countmax(this.far.orig) + 1;
        fr.sort = new Integer(s[1]);
        fr.date.set(s[2]);
        fr.qu = new BigDecimal(s[3]);
        fr.pr = new BigDecimal(s[4]);
        fr.di = new BigDecimal(s[5]);
        fr.vat = new BigDecimal(s[6]);
        if (s.length > 7) {
            fr.text = s[7];
        }
        if (s.length > 8) {
            fr.mj = s[8];
        }
        fr.idh = this.invId;
        if (this.invId != 0) {
            this.far.addrec(MainC.faktur.farjt, MainC.faktur.fart, this.far.orig, fr, fr.id);
        }
    }
}

